@echo off
setlocal enabledelayedexpansion

:: Confirm user wants to proceed
echo *************"Running this script will automatically update the registry path required for HP scanner configuration."*************
echo *************"Please close all instances of HP Scan and Registry Editor, and disconnect any HP scanners connected via USB before running the script to ensure successful execution."*************
echo Do you want to continue? (Y/N)
set /p consent="Enter choice: "

if /i "%consent%" neq "Y" (
    echo Operation cancelled.
    exit /b
)


echo Checking the OS version...
:: --- Detect Windows Version ---
for /f "tokens=4-5 delims=[] " %%a in ('ver') do set "osver=%%a"
set "osver=%osver:Version =%"
set "osver=%osver:.0=%"

:: Windows 11 = Version 10.0.22000 or higher
for /f "tokens=2 delims=." %%v in ("%osver%") do set "build=%%v"

if %build% LSS 22000 (
    echo.
    echo ==========================================
    echo This script can only be run on Windows 11.
    echo Detected OS version: %osver%
    echo Exiting without making changes.
    echo ==========================================
    echo.
    pause
    exit /b
)

echo.
echo Detected Windows 11 (build %build%). Proceeding...
echo.

:: ==========================================
::  Import IPPUSB_Exclusion_Win11 Registry Data
:: ==========================================

:: Create a temporary .reg file in the same folder as this script
set "ScriptDir=%~dp0"
set "TempRegFile=%ScriptDir%IPPUSB_Exclusion_Win11_temp.reg"
set "RegKey=HKLM\SYSTEM\CurrentControlSet\Control\Print\Monitors\USB Monitor\IppUsbExclusion"

echo.
echo ==========================================
echo    IPP USB Exclusion Configuration Tool
echo ==========================================

:: Check if the registry key exists
reg query "%RegKey%" >nul 2>&1
if errorlevel 1 (
    echo Registry path not found. Creating registry path...
    reg add "%RegKey%" /f >nul 2>&1
    if errorlevel 1 (
        echo ERROR: Failed to create registry path. Please run as Administrator.
        echo.
        pause
        exit /b 1
    ) else (
        echo Registry path created successfully.
    )
) else (
    echo Registry path already exists.
)


(
echo Windows Registry Editor Version 5.00
echo.
echo [HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Print\Monitors\USB Monitor\IppUsbExclusion]
echo "VID_03F0&PID_5605;HP ScanJet Pro 3000 s3"=dword:00000001
echo "VID_03F0&PID_5705;HP ScanJet Enterprise Flow 5000 s4"=dword:00000001
echo "VID_03F0&PID_5805;HP ScanJet Enterprise Flow 7000 s3"=dword:00000001
echo "VID_03F0&PID_8411;HP Digital Sender Flow 7500 fn2"=dword:00000001
echo "VID_03F0&PID_5305;HP ScanJet Pro 3500 f1"=dword:00000001
echo "VID_03F0&PID_5405;HP ScanJet Pro 4500 fn1"=dword:00000001
) > "%TempRegFile%"

echo.
echo Importing registry data...
reg import "%TempRegFile%"
if %errorlevel% equ 0 (
    echo Registry import completed successfully.
) else (
    echo Registry import failed. Please check permissions.
)

:: Clean up
del "%TempRegFile%" >nul 2>&1

echo.
echo Done.
pause
endlocal
exit /b
